
/*! \file BaseTypes.h
    \brief This file holds the basic definitions which includes type & utility macros.
*/


#ifndef _BASETYPES_H
#define _BASETYPES_H
#ifdef __cplusplus
extern "C" {
#endif

#define DX_NULL 				0

typedef unsigned char        	DxUint8_t;

typedef unsigned short       	DxUint16_t;

typedef unsigned long        	DxUint32_t;

typedef unsigned long long 		DxUint64_t;

typedef char		          	DxInt8_t;

typedef char			        DxChar;

typedef signed short         	DxInt16_t;

typedef signed long          	DxInt32_t;

typedef unsigned int       		DxUint_t;

typedef signed int            	DxInt_t;

typedef DxUint16_t				DxWideChar;

typedef DxUint8_t               DxByte_t ;


typedef DxChar                  DxChar_t ; 




typedef enum {
	DX_FALSE = 0,
	DX_TRUE = 1
}DxBool_t;


typedef DxUint32_t	 		    DxStatus;
typedef DxStatus                DxError_t;
typedef unsigned int		    DxSize_t;

#define DX_SUCCESS			0UL 

#define DX_MAX_UINT32		0xFFFFFFFFUL
#define DX_MAX_INT32		0x7FFFFFFFL
#define DX_MIN_INT32		0x80000000L
#define DX_MAX_UINT16		0xFFFFU
#define DX_MAX_UINT8		0xFFU

#define DX_BITS_IN_BYTE     8
#define DX_BITS_IN_DWORD    32
#define DX_GET_LSBS(value, numOfBits) (value & ((1UL << numOfBits) - 1))
#define DX_INFINITE			DX_MAX_UINT32

#define DX_MAX_UINT			((DxUint_t)(-1))

#define DX_MAX(a,b)			((a) > (b) ? (a) : (b))
#define DX_MIN(a,b)			((a) < (b) ? (a) : (b))

#define DX_DIVIDE_ROUND_UP(num, divider)			(((num) + (divider) - 1) / (divider))

#ifdef __cplusplus
}
#endif

#endif /* ifndef _DX_VOS_BASETYPES_H */



